<?php

namespace Factory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Factory extends Model 
{

    protected $table = 'factory';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description');

    public function route()
    {
        return $this->hasMany('FactoryRoute');
    }

}