<?php

namespace Tour;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tour extends Eloquent {

	protected $table = 'tour';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('tour_package_id', 'tour_number', 'name', 'tour_date', 'reschedule_reason', 'vehicle_plate_number');

	public function tourParticipant()
	{
		return $this->hasMany('TourParticipant');
	}

	public function tourFeedback()
	{
		return $this->hasMany('TourFeedback');
	}

	public function tourPackage()
	{
		return $this->hasOne('TourPackage');
	}

}