<?php

namespace TourPackage;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TourPackage extends Eloquent {

	protected $table = 'tour_package';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'minimum_participant', 'maximum_participant');

	public function tourRoutes()
	{
		return $this->hasManyThrough('FactoryRoute', 'tour_route');
	}

}