<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTourParticipantTable extends Migration {

	public function up()
	{
		Schema::create('tour_participant', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tour_id')->unsigned();
			$table->string('name');
			$table->string('age');
			$table->enum('sex', array('male', 'female'));
			$table->string('email');
			$table->string('city');
			$table->tinyInteger('is_leader')->default('0');
			$table->tinyInteger('is_special_need')->default('0');
			$table->string('verification_code')->nullable();
			$table->timestamp('verified_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tour_participant');
	}
}