<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTourTable extends Migration {

	public function up()
	{
		Schema::create('tour', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tour_package_id')->unsigned();
			$table->string('tour_number');
			$table->string('name');
			$table->datetime('tour_date');
			$table->text('reschedule_reason');
			$table->enum('vehicle_type', array('tour-bus', 'private-car'));
			$table->string('vehicle_plate_number');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tour');
	}
}