<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tour', function(Blueprint $table) {
			$table->foreign('tour_package_id')->references('id')->on('tour_package')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tour_participant', function(Blueprint $table) {
			$table->foreign('tour_id')->references('id')->on('tour')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tour_feedback', function(Blueprint $table) {
			$table->foreign('tour_id')->references('id')->on('tour')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('factory_route', function(Blueprint $table) {
			$table->foreign('factory_id')->references('id')->on('factory')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tour_route', function(Blueprint $table) {
			$table->foreign('tour_package_id')->references('id')->on('tour_package')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tour_route', function(Blueprint $table) {
			$table->foreign('factory_route_id')->references('id')->on('factory_route')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tour', function(Blueprint $table) {
			$table->dropForeign('tour_tour_package_id_foreign');
		});
		Schema::table('tour_participant', function(Blueprint $table) {
			$table->dropForeign('tour_participant_tour_id_foreign');
		});
		Schema::table('tour_feedback', function(Blueprint $table) {
			$table->dropForeign('tour_feedback_tour_id_foreign');
		});
		Schema::table('factory_route', function(Blueprint $table) {
			$table->dropForeign('factory_route_factory_id_foreign');
		});
		Schema::table('tour_route', function(Blueprint $table) {
			$table->dropForeign('tour_route_tour_package_id_foreign');
		});
		Schema::table('tour_route', function(Blueprint $table) {
			$table->dropForeign('tour_route_factory_route_id_foreign');
		});
	}
}