<?php

namespace Tour;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tour extends Model 
{

    protected $table = 'tour';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('tour_package_id', 'tour_number', 'name', 'tour_date', 'reschedule_reason', 'vehicle_plate_number');

    public function tourParticipant()
    {
        return $this->hasMany('TourParticipant');
    }

    public function tourFeedback()
    {
        return $this->hasMany('TourFeedback');
    }

    public function tourPackage()
    {
        return $this->hasOne('TourPackage');
    }

}