<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEnrollmentsTable extends Migration {

	public function up()
	{
		Schema::create('enrollments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('group_id')->unsigned();
			$table->integer('level_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('role');
			$table->integer('points');
			$table->string('previous_individual_position');
			$table->string('previous_group_position');
			$table->decimal('percentage', 8,2);
			$table->integer('n_problems_ttempts');
			$table->integer('n_problems_solved');
			$table->text('comment');
			$table->tinyInteger('anonymous')->default('0');
			$table->decimal('rating');
			$table->timestamp('rated_at');
			$table->integer('streak');
			$table->integer('n_resouces_views');
			$table->integer('n_topic_replies_likes');
			$table->timestamps();
			$table->integer('n_twitter_shares');
			$table->integer('n_facebook_shares');
		});
	}

	public function down()
	{
		Schema::drop('enrollments');
	}
}