<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResourcesTable extends Migration {

	public function up()
	{
		Schema::create('resources', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('subject_id')->unsigned();
			$table->string('name', 255);
			$table->text('description');
			$table->integer('duration');
			$table->string('url', 500)->nullable();
			$table->string('type', 50);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('resources');
	}
}