<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWallMessagesTable extends Migration {

	public function up()
	{
		Schema::create('wall_messages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('wall_message_id')->unsigned()->nullable();
			$table->integer('reached_achievement_id')->unsigned();
			$table->integer('reported_user_id')->unsigned()->nullable();
			$table->text('message');
			$table->boolean('spam')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('wall_messages');
	}
}