<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('subject_id')->unsigned();
			$table->string('name', 255);
			$table->date('start_date');
			$table->string('end_date');
			$table->smallInteger('levels');
			$table->integer('registration_type');
			$table->string('image', 255);
			$table->decimal('threshold', 8,3);
			$table->decimal('approval_percentage', 8,2);
			$table->tinyInteger('has_certificate')->default('0');
			$table->string('registration_timing', 10);
			$table->text('supported_by');
			$table->tinyInteger('paid')->default('0');
			$table->decimal('cost', 8,2);
			$table->integer('n_modules');
			$table->integer('n_problems');
			$table->timestamps();
			$table->timestamp('deleted_at');
			$table->integer('n_resources');
			$table->string('pin', 30);
			$table->tinyInteger('type');
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}