<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModuleProblemTable extends Migration {

	public function up()
	{
		Schema::create('module_problem', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('module_id')->unsigned();
			$table->integer('problem_id')->unsigned();
			$table->integer('best_user_id')->unsigned();
			$table->integer('n_problems_attempts')->default('0');
			$table->boolean('n_problems_solved')->default(0);
			$table->decimal('best_score', 8,2);
			$table->timestamps();
			$table->tinyInteger('visible')->default('1');
			$table->integer('order');
		});
	}

	public function down()
	{
		Schema::drop('module_problem');
	}
}