<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemberAddressesTable extends Migration {

	public function up()
	{
		Schema::create('member_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('member_id')->unsigned()->index();
			$table->tinyInteger('is_default')->default('0');
			$table->string('fullname', 150);
			$table->string('phone', 30)->nullable();
			$table->string('address', 255);
			$table->integer('district_id')->unsigned()->index();
			$table->integer('amphur_id')->unsigned()->index();
			$table->integer('province_id')->unsigned()->index();
			$table->integer('zipcode_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('member_addresses');
	}
}