<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration {

	public function up()
	{
		Schema::create('members', function(Blueprint $table) {
			$table->increments('id');
			$table->string('fullname', 150)->nullable();
			$table->string('email', 100);
			$table->string('password', 255)->nullable();
			$table->string('phone', 30)->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->date('date_of_birth')->nullable();
			$table->tinyInteger('activated')->index()->default('0');
			$table->string('activation_code', 255)->nullable();
			$table->datetime('activated_at');
			$table->datetime('last_login');
			$table->rememberToken('rememberToken');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('members');
	}
}