<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductImagesTable extends Migration {

	public function up()
	{
		Schema::create('product_images', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned()->nullable()->index();
			$table->tinyInteger('is_cover')->default('0');
			$table->string('image_name', 255);
			$table->string('caption', 255)->nullable();
			$table->smallInteger('position')->default('0');
			$table->tinyInteger('active')->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_images');
	}
}