<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nickname', 50)->nullable();
			$table->string('email', 150)->unique();
			$table->string('password', 150)->nullable();
			$table->tinyInteger('group')->default('0');
			$table->tinyInteger('active')->index()->default('1');
			$table->rememberToken('rememberToken');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}