<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticleCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('article_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 255)->unique()->nullable();
			$table->string('name', 100);
			$table->text('description')->nullable();
			$table->tinyInteger('active')->index()->default('1');
			$table->smallInteger('position')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('article_categories');
	}
}