<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 100)->unique();
			$table->text('description')->nullable();
			$table->decimal('min_spent')->default('0');
			$table->decimal('discount_amount')->default('0');
			$table->tinyInteger('is_percent')->default('0');
			$table->decimal('discount_limit')->default('0');
			$table->tinyInteger('is_free_shipping')->default('0');
			$table->tinyInteger('active')->index()->default('1');
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date');
			$table->integer('usage_limit_per_user')->nullable();
			$table->integer('usage_limit_per_coupon_count')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}