<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderPaymentsTable extends Migration {

	public function up()
	{
		Schema::create('order_payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned()->nullable()->index();
			$table->tinyInteger('payment_status')->default('0');
			$table->integer('payment_channel_id')->unsigned()->nullable()->index();
			$table->integer('payment_bank_account_id')->unsigned()->nullable()->index();
			$table->decimal('payment_total')->default('0');
			$table->datetime('payment_at');
			$table->string('file_name', 200)->nullable();
			$table->text('remark')->nullable();
			$table->string('fullname', 150)->nullable();
			$table->string('phone', 30)->nullable();
			$table->string('email', 100)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_payments');
	}
}