<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Article extends Eloquent {

	protected $table = 'articles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->belongsTo('App\ArticleCategory', 'category_id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'created_by');
	}

}