<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function payment()
	{
		return $this->hasOne('App\OrderPayment', 'order_id');
	}

	public function products()
	{
		return $this->hasMany('App\OrderProduct', 'order_id');
	}

	public function member()
	{
		return $this->belongsTo('App\Member', 'member_id');
	}

	public function coupon()
	{
		return $this->belongsTo('App\Coupon', 'coupon_id');
	}

}