<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderProductsTable extends Migration {

	public function up()
	{
		Schema::create('order_products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned()->index();
			$table->string('name', 150);
			$table->integer('option_id')->unsigned()->index();
			$table->string('sku', 255);
			$table->string('option_type_name', 100);
			$table->string('option_type_value', 100);
			$table->string('option_type_unit', 50);
			$table->decimal('regular_price')->default('0');
			$table->decimal('sale_price')->default('0');
			$table->integer('warranty_id')->unsigned()->nullable()->index();
			$table->date('warranty_expire_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_products');
	}
}