<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductOptionsTable extends Migration {

	public function up()
	{
		Schema::create('product_options', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned()->index();
			$table->integer('option_child_type_id')->unsigned()->nullable()->index();
			$table->string('sku', 255)->nullable();
			$table->string('image_name', 255)->nullable();
			$table->decimal('regular_price')->default('0');
			$table->decimal('sale_price')->default('0');
			$table->tinyInteger('active')->index()->default('1');
			$table->tinyInteger('position')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_options');
	}
}