<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->belongsTo('App\Category', 'category_id');
	}

	public function specification()
	{
		return $this->hasOne('App\ProductSpecification', 'product_id');
	}

	public function options()
	{
		return $this->hasMany('App\ProductOption', 'product_id');
	}

	public function optiontype()
	{
		return $this->belongsTo('App\ProductOptionType', 'option_parent_type_id');
	}

	public function images()
	{
		return $this->hasMany('App\ProductImage', 'product_id');
	}

}