<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductOptionTypesTable extends Migration {

	public function up()
	{
		Schema::create('product_option_types', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent')->unsigned()->nullable()->index();
			$table->string('name', 100);
			$table->string('value', 100)->nullable();
			$table->string('unit', 50)->nullable();
			$table->tinyInteger('active')->default('1');
			$table->smallInteger('position')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_option_types');
	}
}