<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Headline extends Model 
{

    protected $table = 'headlines';
    public $timestamps = true;
    protected $fillable = array('user_id', 'title', 'excerpt', 'image_url', 'link_url', 'article_id', 'status');

    public function article()
    {
        return $this->belongsTo('Article');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}