<?php

namespace App;

class Asset extends Eloquent {

	protected $table = 'assets';
	public $timestamps = true;
	protected $fillable = array('user_id', 'tipe_asset_id', 'kronologis', 'nama_barang_id', 'nup', 'lokasi', 'wilayah_id', 'luas_tanah', 'penggunaan', 'luas_dasar_gedung', 'luas_gedung', 'jumlah_lantai', 'tgl_perolehan', 'nilai_satuan', 'jumlah_nilai', 'kondisi_id', 'status_sengketa', 'no_psp', 'dokumen_psp', 'ket_penggunaan', 'kib', 'permasalahan', 'no_sip', 'no_sk_penetapan', 'latitude', 'longitude', 'satker_id', 'status_penggunaan_id', 'plat_nomor', 'kubikasi', 'merek_id', 'jenis_kendaraan', 'tahun_pembuatan');

	public function tipe_asset()
	{
		return $this->belongsTo('App\TipeAsset', 'tipe_asset_id');
	}

	public function file()
	{
		return $this->hasMany('App\Document');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

	public function image()
	{
		return $this->hasMany('App\Image');
	}

	public function ruangan()
	{
		return $this->hasMany('App\Ruangan');
	}

	public function kondisi()
	{
		return $this->belongsTo('App\Kondisi', 'kondisi_id');
	}

	public function satker()
	{
		return $this->belongsTo('App\Satker', 'satker_id');
	}

	public function kronologi()
	{
		return $this->hasMany('App\Kronologi');
	}

	public function permasalahan()
	{
		return $this->belongsToMany('App\Permasalahan');
	}

	public function status_penggunaan()
	{
		return $this->belongsTo('App\StatusPenggunaan', 'status_penggunaan_id');
	}

	public function nama_barang()
	{
		return $this->belongsTo('App\NamaBarang', 'nama_barang_id');
	}

	public function wilayah()
	{
		return $this->belongsTo('App\Wilayah', 'wilayah_id');
	}

	public function merek()
	{
		return $this->belongsTo('App\Merek', 'merek_id');
	}

	public function log_asset()
	{
		return $this->hasMany('App\LogAsset');
	}

}