<?php

namespace App;

class Menu extends Eloquent {

	protected $table = 'menus';
	public $timestamps = true;
	protected $fillable = array('menu_title', 'target', 'article_id', 'link_url', 'parent_id', 'order_number', 'menu_item_id');

	public function article()
	{
		return $this->belongsTo('Article');
	}

	public function children()
	{
		return $this->hasMany('Menu', 'parent_id');
	}

	public function menu_item()
	{
		return $this->belongsTo('MenuItem', 'menu_item_id');
	}

}