<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->integer('asset_id');
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->string('filename')->nullable();
			$table->string('link_url')->nullable();
			$table->integer('file_category_id');
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}