<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Ruangan extends Model 
{

    protected $table = 'ruangans';
    public $timestamps = true;
    protected $fillable = array('asset_id', 'nama_ruangan', 'luas_ruangan', 'pegawai', 'tabung_kebakaran', 'cctv', 'lantai');

    public function asset()
    {
        return $this->belongsTo('App\Asset', 'asset_id');
    }

    public function image()
    {
        return $this->hasMany('App\Image');
    }

}