<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHeadlinesTable extends Migration {

	public function up()
	{
		Schema::create('headlines', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->string('title');
			$table->text('excerpt');
			$table->string('image_url')->nullable();
			$table->string('link_url')->nullable();
			$table->integer('article_id')->nullable();
			$table->string('status')->default('default');
		});
	}

	public function down()
	{
		Schema::drop('headlines');
	}
}