<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function store()
    {
        return $this->hasOne('Store', 'user_id');
    }

    public function wallet()
    {
        return $this->hasOne('Wallets', 'user_id');
    }

    public function fav()
    {
        return $this->hasMany('Favourites', 'user_id');
    }

    public function reservations()
    {
        return $this->hasMany('Reservation', 'client_id');
    }

    public function reservationCach()
    {
        return $this->hasMany('Reservation_cashes', 'client_id');
    }

    public function userRole()
    {
        return $this->hasOne('UserRole', 'user_id');
    }

}