<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->char('code', 50);
			$table->integer('number_of_use');
			$table->date('expiration_date');
			$table->tinyInteger('is_active');
			$table->enum('coupon_type', array('fixed', 'percentage'));
			$table->integer('amount');
			$table->tinyInteger('all_stores');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}