<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeSessionsTable extends Migration {

	public function up()
	{
		Schema::create('employee_sessions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('employee_id')->nullable();
			$table->date('session_date');
			$table->time('session_from');
			$table->bigInteger('reservation_id');
			$table->time('session_to');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('employee_sessions');
	}
}