<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('store_id');
			$table->char('name', 255);
			$table->char('mobile', 10);
			$table->string('email', 255);
			$table->string('photo', 255);
			$table->tinyInteger('is_active');
			$table->integer('rate')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}