<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id');
			$table->enum('payment_method', array('cash', 'online_payment', 'wallet'));
			$table->tinyInteger('is_paid');
			$table->tinyInteger('is_donation');
			$table->enum('status', array('pending', 'in_progress', 'completed', 'canceled'));
			$table->double('tax');
			$table->double('commision');
			$table->double('wallet_amount');
			$table->double('sub_total');
			$table->double('total');
			$table->double('coupon_discount');
			$table->bigInteger('coupon_id');
			$table->double('other_amount');
			$table->text('payment_data');
			$table->bigInteger('store_id');
			$table->enum('reservation_type', array('male', 'female'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}