<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreTimingsTable extends Migration {

	public function up()
	{
		Schema::create('store_timings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('store_id');
			$table->enum('day', array('sat', 'sun', 'mon', 'tue', 'wed', 'thu', 'fr'));
			$table->time('start_from');
			$table->time('end_to');
			$table->enum('type', array('1', '2', '3', '4'));
			$table->time('start_from_2');
			$table->time('end_to_2');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('store_timings');
	}
}