<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationCashesTable extends Migration {

	public function up()
	{
		Schema::create('reservation_cashes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id');
			$table->integer('store_service_id');
			$table->integer('employee_id');
			$table->double('price', 8,2);
			$table->date('reservation_date');
			$table->time('reservation_time');
			$table->time('reservation_end');
			$table->integer('session_time');
			$table->integer('group_id');
			$table->enum('reservation_type', array('male', 'female'));
		});
	}

	public function down()
	{
		Schema::drop('reservation_cashes');
	}
}