<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('key', 255);
			$table->text('value');
			$table->string('group');
			$table->string('type')->default('number, text, textarea, email, file');
			$table->integer('sort');
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}