<?php

namespace Employee;

use Illuminate\Database\Eloquent\Model;

class Employee extends Model 
{

    protected $table = 'employees';
    public $timestamps = true;

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function sessions()
    {
        return $this->hasMany('EmployeeSessions', 'employee_id');
    }

    public function times()
    {
        return $this->hasMany('EmployeeTimes', 'employee_id');
    }

    public function reviews()
    {
        return $this->hasMany('ReviewEmployee', 'employee_id');
    }

    public function services()
    {
        return $this->hasMany('EmployeeService', 'employee_id');
    }

}