<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFcmTokensTable extends Migration {

	public function up()
	{
		Schema::create('fcm_tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id');
			$table->text('value');
			$table->enum('device_type', array('android', 'ios'));
			$table->char('lang');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fcm_tokens');
	}
}