<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationItemsTable extends Migration {

	public function up()
	{
		Schema::create('reservation_items', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('reservation_id');
			$table->bigInteger('store_service_id');
			$table->bigInteger('employee_id');
			$table->double('price', 8,2);
			$table->date('reservation_date');
			$table->time('reservation_time');
			$table->time('reservation_end');
			$table->integer('session_time');
			$table->tinyInteger('notified');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reservation_items');
	}
}