<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'mobile', 'city_id', 'type', 'password', 'status', 'code', 'email', 'image', 'wallet', 'total_commission');

	public function city()
	{
		return $this->belongsTo('App\Models\City', 'city_id');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Models\Category', 'driver_categories', 'user_id', 'category_id');
	}

	public function addresses()
	{
		return $this->hasMany('App\Models\Address', 'user_id');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification', 'user_id');
	}

	public function carts()
	{
		return $this->hasMany('App\Models\Cart', 'user_id');
	}

	public function user_orders()
	{
		return $this->hasMany('App\Models\Order', 'user_id');
	}

	public function family_orders()
	{
		return $this->hasMany('App\Models\Order', 'family_id');
	}

}