<?php

namespace App\Models;

class Cart extends Eloquent {

	protected $table = 'carts';
	public $timestamps = true;
	protected $fillable = array('user_id', 'family_id', 'product_id', 'count', 'price', 'status');

	public function user()
	{
		return $this->belongsTo('Admin', 'user_id');
	}

	public function product()
	{
		return $this->belongsTo('App\Models\Product', 'product_id');
	}

	public function family()
	{
		return $this->belongsTo('User', 'family_id');
	}

}