<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriversTable extends Migration {

	public function up()
	{
		Schema::create('drivers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('lat', 191)->nullable();
			$table->string('lng', 191)->nullable();
			$table->string('address', 191)->nullable();
			$table->string('id_number', 191)->nullable();
			$table->string('license_image', 191)->nullable();
			$table->string('license_number', 191)->nullable();
			$table->string('bank_name', 191)->nullable();
			$table->string('bank_number', 191)->nullable();
			$table->string('iban_number', 191)->nullable();
			$table->enum('online', array('true', 'false'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('drivers');
	}
}