<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResturantsTable extends Migration {

	public function up()
	{
		Schema::create('resturants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('phone');
			$table->integer('region_id')->unsigned();
			$table->string('password', 255);
			$table->string('whatsup', 255);
			$table->string('image', 255);
			$table->decimal('minimum_order');
			$table->string('contact_phone', 255);
			$table->datetime('delivery_charge');
			$table->boolean('activate');
			$table->boolean('available');
		});
	}

	public function down()
	{
		Schema::drop('resturants');
	}
}