<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attribute extends Eloquent {

	protected $table = 'attributes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'descirption');

	public function values()
	{
		return $this->hasMany('App\Models\PostAttributeValue', 'attribute_id');
	}

	public function postTypes()
	{
		return $this->belongsToMany('App\Models\LookupPostType', 'posts_type_attributes_join', 'attribute_id', 'post_type_id');
	}

	public function attributes()
	{
		return $this->belongsToMany('App\Models\Post', 'posts_type_attributes_join', 'post_type_id', 'attribute_id');
	}

}