<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LookupPostType extends Eloquent {

	protected $table = 'lookup_post_type';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'display', 'description');

	public function attributes()
	{
		return $this->belongsToMany('App\Models\Attribute', 'posts_type_attribute_join', 'post_type_id', 'attribute_id');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Models\Post', 'post_type_id');
	}

}