<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityPackageTable extends Migration {

	public function up()
	{
		Schema::create('entity_package', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('package_id')->unsigned()->nullable();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->string('name', 255)->nullable();
			$table->bigInteger('duration')->nullable();
			$table->bigInteger('purchased_quota')->nullable();
			$table->bigInteger('available_quota')->nullable();
			$table->float('price')->nullable();
			$table->timestamp('end_date')->nullable();
			$table->timestamp('start_date')->nullable();
			$table->integer('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('entity_package');
	}
}