<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityUsersTable extends Migration {

	public function up()
	{
		Schema::create('entity_users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('branch_id')->unsigned()->nullable();
			$table->timestamp('start_date')->nullable();
			$table->datetime('end_date')->nullable();
			$table->string('phone_number', 12)->nullable();
			$table->string('en_team', 255)->nullable();
			$table->string('ar_team', 255)->nullable();
			$table->string('ar_department', 255)->nullable();
			$table->string('en_department', 255)->nullable();
			$table->string('national_id', 30)->nullable();
			$table->integer('status')->nullable();
			$table->string('ar_job_title', 255)->nullable();
			$table->string('en_job_title', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('entity_users');
	}
}